package gov.va.med.mhv.sm.web.utils;


public class HtmlHelper {
	static String filler = "                    ";
	private HtmlHelper() {}

	public static String encode(String raw) {
		if ( raw == null ) return "";
		// Order matters here & must be first and line breaks last
		String result = raw.replaceAll("&", "&amp;");
		result = result.replaceAll(">", "&gt;");
		result = result.replaceAll("<", "&lt;");
		result = result.replaceAll("\"", "&quot;");
		result = result.replaceAll("\n", "<br />");
		return result;
	}


	public static String untabify(String s,int tabSize)
    {
          StringBuffer result = new StringBuffer();
          String lfiller = filler.substring(0, tabSize);
          String lines[] = s.replaceAll("\r","").split("\n");
          for (String line : lines) {
                String[] chunks = line.split("\t");
                StringBuffer newline = new StringBuffer((chunks.length== 0? line:""));
                int current = 0;
                for (String chunk:chunks) {
                      int cur = (newline.length() + chunk.length());
                      newline.append(chunk);
                      if( chunks.length > ++current)
                    	  newline.append(lfiller.substring(cur % tabSize));
                }
                result.append(newline).append("\n");
          }
          return result.toString();
    }

}
